--***********************************************************
--**                    THE INDIE STONE                    **
--**********************************************************
require "TimedActions/ISLockDoor"

local upperLayer = {}
upperLayer.ISLockDoor = {}

upperLayer.ISLockDoor.isValid = ISLockDoor.isValid
function ISLockDoor:isValid()
	upperLayer.ISLockDoor.isValid(self)
	local keyId2 = instanceof(self.door, "IsoDoor") and self.door:checkKeyId() or self.door:getKeyId()
	--if (not door) or (door and door:IsOpen()) or (not doorKeyId) then return end
	local player = self.character --getSpecificPlayer(player)
	local cell = player:getCell() 
	local x = player:getX()
	local y = player:getY()
	local z = player:getZ()
	local sameSquare = (self.door:getSquare() == player:getSquare())
	local doorNorth = (self.door:getNorth())
	local playerInside = not player:getCurrentSquare():Is(IsoFlagType.exterior)
	local outsideDoor = false
	
	if playerInside then  
		local testSquare = nil
		if doorNorth and sameSquare then testSquare = 	cell:getGridSquare(x, y-1, z)
		elseif doorNorth and (not sameSquare) then testSquare = 	cell:getGridSquare(x, y+1, z)
		elseif (not doorNorth) and sameSquare then testSquare = 	cell:getGridSquare(x-1, y, z)
		elseif (not doorNorth) and (not sameSquare) then testSquare = 	cell:getGridSquare(x+1, y, z)
		end
		outsideDoor = testSquare:Is(IsoFlagType.exterior)
	end
	
	if (outsideDoor) then return true end --and (not player:getInventory():haveThisKeyId(doorKeyId)) then doorKeyId = nil end
	--if self.lock then return true end




	if not self.character:getInventory():haveThisKeyId(keyId2) then 
		--self.character:getEmitter():playSound("DoorIsLocked") 
		--self.door:getProperties():Set("forceLocked", "true") 
		return false
	else 
		return true
	end
	
end

upperLayer.ISLockDoor.perform = ISLockDoor.perform
function ISLockDoor:perform()
	upperLayer.ISLockDoor.perform(self)
	if self.door:getModData()["interChange"] == true then return end
	

	local cell = self.character:getCell() 
	local x = self.character:getX()
	local y = self.character:getY()
	local z = self.character:getZ()
	local sameSquare = (self.door:getSquare() == self.character:getSquare())
	local doorNorth = (self.door:getNorth())
	local playerInside = not self.character:getCurrentSquare():Is(IsoFlagType.exterior)
	local insideDoor = false
	
	if playerInside then  
		local testSquare = nil
		if doorNorth and sameSquare then testSquare = 	cell:getGridSquare(x, y-1, z)
		elseif doorNorth and (not sameSquare) then testSquare = 	cell:getGridSquare(x, y+1, z)
		elseif (not doorNorth) and sameSquare then testSquare = 	cell:getGridSquare(x-1, y, z)
		elseif (not doorNorth) and (not sameSquare) then testSquare = 	cell:getGridSquare(x+1, y, z)
		end
		insideDoor = not testSquare:Is(IsoFlagType.exterior)
	end
	
	if (insideDoor) then
		if self.lock then
			local doubleDoorObjects = buildUtil.getDoubleDoorObjects(self.door)
		    local garageDoorObjects = buildUtil.getGarageDoorObjects(self.door)
			local square = self.door:getSquare()
			local key = self.door:getKeyId()
			local north = self.door:getNorth()
			local cell = getWorld():getCell()
		    --local spriteName = self.door:getSprite():getName()
		    local healtDoor = self.door:getHealth()
		    local specialDoors = false
		    if north then
		        self.north = true
		    else
		        self.north = false
		    end
	    	if doubleDoorObjects then 
				for i=1,#doubleDoorObjects do
					local object = doubleDoorObjects[i]
					local square = object:getSquare()
					local cell = getWorld():getCell()
			    	local healtDoor = object:getHealth()
				    local doubleDoor = IsoDoor.new(cell, square, object:getSprite(), self.north)
			    	square:transmitRemoveItemFromSquare(object)
			    	square:AddSpecialObject(doubleDoor)
			    	doubleDoor:setHealth(healtDoor)
			    	doubleDoor:setKeyId(key)
			    	doubleDoor:transmitCompleteItemToServer()
			    	cell:setDrag(nil, self.character:getPlayerNum())
					doubleDoor:getProperties():Set("forceLocked", "true")
			        doubleDoor:setLockedByKey(true);
			        specialDoors = true
			        doubleDoor:getModData()["interChange"] = true
					if isClient() then doubleDoor:transmitModData() end
				end
			end
			if garageDoorObjects then
				for i=1,#garageDoorObjects do
					local object = garageDoorObjects[i]
					local square = object:getSquare()
					local cell = getWorld():getCell()
			    	local healtDoor = object:getHealth()
				    local garageDoor = IsoDoor.new(cell, square, object:getSprite(), self.north)
			    	square:transmitRemoveItemFromSquare(object)
			    	square:AddSpecialObject(garageDoor)
			    	garageDoor:setHealth(healtDoor)
			    	garageDoor:setKeyId(key)
			    	garageDoor:transmitCompleteItemToServer()
			    	cell:setDrag(nil, self.character:getPlayerNum())
					garageDoor:getProperties():Set("forceLocked", "true")
			        garageDoor:setLockedByKey(true);
			        specialDoors = true
			        garageDoor:getModData()["interChange"] = true
					if isClient() then garageDoor:transmitModData() end
				end
			end 
			if specialDoors == false then
				self.javaObject = IsoDoor.new(cell, square, self.door:getSprite(), self.north)
				self.javaObject:setHealth(healtDoor)
				self.javaObject:setKeyId(key)
				square:transmitRemoveItemFromSquare(self.door)
				square:AddSpecialObject(self.javaObject)
				self.javaObject:transmitCompleteItemToServer()
				cell:setDrag(nil, self.character:getPlayerNum())	
				self.door = self.javaObject
				self.character:faceThisObject(self.door)
				self.door:getProperties():Set("forceLocked", "true")
	    		self.door:setLockedByKey(true);
	    		self.door:getModData()["interChange"] = true
				if isClient() then self.door:transmitModData() end
	    	end
	    end
	end
end



--   CANCEL CODE
